/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.perk;

import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalAttribute;
import dev.toma.gunsrpg.common.item.perk.IPerkHolder;
import dev.toma.gunsrpg.common.item.perk.PerkItem;
import dev.toma.gunsrpg.common.item.perk.PerkVariant;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CrystalItem
extends PerkItem
implements IPerkHolder {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private static final ITextComponent TEXT_ATTRIBUTES = new TranslationTextComponent("crystal.stat.attributes");

    public CrystalItem(String name, PerkVariant variant) {
        super(name, variant, new Item.Properties().func_200916_a(ModTabs.ITEM_TAB).func_200917_a(1));
    }

    public static Crystal getCrystal(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        CompoundNBT crystalNbt = nbt.func_74775_l("crystal");
        return Crystal.fromNbt(crystalNbt);
    }

    public static void addCrystal(ItemStack stack, Crystal crystal) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_218657_a("crystal", (INBT)crystal.toNbt());
        stack.func_77982_d(nbt);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        Crystal crystal = CrystalItem.getCrystal(stack);
        if (crystal == null) {
            return;
        }
        list.add((ITextComponent)new TranslationTextComponent("crystal.stat.level", new Object[]{new StringTextComponent(String.valueOf(crystal.getLevel())).func_240699_a_(TextFormatting.AQUA)}));
        list.add(TEXT_ATTRIBUTES);
        for (CrystalAttribute attribute : crystal.listAttributes()) {
            Perk perk = attribute.getPerk();
            ITextComponent name = perk.getDisplayName();
            TextFormatting formatting = attribute.getType() == PerkType.BUFF ? TextFormatting.GREEN : TextFormatting.RED;
            String pct = DECIMAL_FORMAT.format(attribute.getValue() * 100.0f);
            list.add((ITextComponent)new TranslationTextComponent("crystal.stat.attribute", new Object[]{name.getString(), pct}).func_240699_a_(formatting));
        }
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DECIMAL_FORMAT.setDecimalFormatSymbols(symbols);
    }
}

